/*
 * Decompiled with CFR 0.152.
 */
package client.teavm;

import client.teavm.common.IImportedApi;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import libsidplay.components.printer.IPaper;
import org.teavm.interop.Import;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSByRef;
import org.teavm.jso.JSObject;
import org.teavm.jso.browser.Window;
import org.teavm.jso.core.JSMapLike;
import org.teavm.jso.core.JSNumber;
import org.teavm.jso.core.JSObjects;
import org.teavm.jso.core.JSString;
import org.teavm.jso.typedarrays.Atomics;
import org.teavm.jso.typedarrays.Int32Array;
import org.teavm.jso.typedarrays.Int8Array;
import org.teavm.jso.typedarrays.Uint8Array;

public final class ImportedApiSAB
implements IImportedApi {
    private static final String MODULE_NAME = "jsidplay2";
    private static final int WAIT_TIMEOUT = 50;
    private Int32Array jsControlBuffer;
    private Int8Array jsSampleBuffer;
    private Uint8Array jsPixelBuffer;
    private List<Map<String, Int8Array>> jsGaugeBuffersByChipNum = IntStream.range(0, 3).mapToObj(i -> new HashMap()).collect(Collectors.toList());

    @Override
    public void initControlBuffer() {
        int controlBufferLen = 5;
        ByteBuffer control = ByteBuffer.allocateDirect(controlBufferLen * 4).order(ByteOrder.LITTLE_ENDIAN);
        this.jsControlBuffer = Int32Array.fromJavaBuffer((Buffer)control);
        control.putInt(0, 0);
        control.putInt(4, 0);
        for (int i = 0; i < 3; ++i) {
            control.putInt((2 + i) * 4, 0);
        }
        JSMapLike message = (JSMapLike)JSObjects.create();
        message.set("eventType", (Object)JSString.valueOf((String)"INIT_CONTROL_BUFFER_SAB"));
        JSMapLike eventData = (JSMapLike)JSObjects.create();
        eventData.set("controlBuffer", (Object)this.jsControlBuffer);
        message.set("eventData", (Object)eventData);
        Window.worker().postMessage((JSObject)message);
    }

    @Override
    public ByteBuffer initSampleBuffer(int chunkFrames, int channels) {
        ByteBuffer samples = ByteBuffer.allocateDirect(chunkFrames * 2 * channels).order(ByteOrder.LITTLE_ENDIAN);
        this.jsSampleBuffer = Int8Array.fromJavaBuffer((Buffer)samples);
        JSMapLike message = (JSMapLike)JSObjects.create();
        message.set("eventType", (Object)JSString.valueOf((String)"INIT_SAMPLE_BUFFER_SAB"));
        JSMapLike eventData = (JSMapLike)JSObjects.create();
        eventData.set("sampleBuffer", (Object)this.jsSampleBuffer);
        message.set("eventData", (Object)eventData);
        Window.worker().postMessage((JSObject)message);
        return samples;
    }

    @Override
    public ByteBuffer initPixelBuffer(int maxWidth, int maxHeight) {
        ByteBuffer pixels = ByteBuffer.allocateDirect(maxWidth * maxHeight << 2).order(ByteOrder.BIG_ENDIAN);
        this.jsPixelBuffer = Uint8Array.fromJavaBuffer((Buffer)pixels);
        JSMapLike message = (JSMapLike)JSObjects.create();
        message.set("eventType", (Object)JSString.valueOf((String)"INIT_PIXEL_BUFFER_SAB"));
        JSMapLike eventData = (JSMapLike)JSObjects.create();
        eventData.set("pixelBuffer", (Object)this.jsPixelBuffer);
        message.set("eventData", (Object)eventData);
        Window.worker().postMessage((JSObject)message);
        return pixels;
    }

    @Override
    public ByteBuffer initGaugeBuffer(String type, int chipNum, int pathLength) {
        ByteBuffer path = ByteBuffer.allocateDirect(pathLength * 4).order(ByteOrder.LITTLE_ENDIAN);
        this.jsGaugeBuffersByChipNum.get(chipNum).put(type, Int8Array.fromJavaBuffer((Buffer)path));
        JSMapLike message = (JSMapLike)JSObjects.create();
        message.set("eventType", (Object)JSString.valueOf((String)"INIT_GAUGE_SAB"));
        JSMapLike eventData = (JSMapLike)JSObjects.create();
        eventData.set("type", (Object)JSString.valueOf((String)type));
        eventData.set("chipNum", (Object)JSNumber.valueOf((int)chipNum));
        eventData.set("gauge", (Object)((JSObject)this.jsGaugeBuffersByChipNum.get(chipNum).get(type)));
        message.set("eventData", (Object)eventData);
        Window.worker().postMessage((JSObject)message);
        return path;
    }

    @Override
    public void processSamples(ByteBuffer sampleBuffer, float[] lookupTable) {
        Atomics.store((Int32Array)this.jsControlBuffer, (int)0, (int)1);
        JSMapLike message = (JSMapLike)JSObjects.create();
        message.set("eventType", (Object)JSString.valueOf((String)"SAMPLES_SAB"));
        Window.worker().postMessage((JSObject)message);
        while (Atomics.load((Int32Array)this.jsControlBuffer, (int)0) == 1) {
            Atomics.wait((Int32Array)this.jsControlBuffer, (int)0, (int)1, (int)50);
        }
    }

    @Override
    public void processPixels(ByteBuffer pixelBuffer) {
        Atomics.store((Int32Array)this.jsControlBuffer, (int)1, (int)1);
        JSMapLike message = (JSMapLike)JSObjects.create();
        message.set("eventType", (Object)JSString.valueOf((String)"FRAME_SAB"));
        Window.worker().postMessage((JSObject)message);
        while (Atomics.load((Int32Array)this.jsControlBuffer, (int)1) == 1) {
            Atomics.wait((Int32Array)this.jsControlBuffer, (int)1, (int)1, (int)50);
        }
    }

    @Override
    public void processOsc(int sidNum, ByteBuffer wav0, String wav0Txt, ByteBuffer wav1, String wav1Txt, ByteBuffer wav2, String wav2Txt, ByteBuffer env0, String env0Txt, ByteBuffer env1, String env1Txt, ByteBuffer env2, String env2Txt, ByteBuffer fre0, String frq0Txt, ByteBuffer frq1, String frq1Txt, ByteBuffer frq2, String frq2Txt, ByteBuffer vol, String volTxt, ByteBuffer res, String resTxt, ByteBuffer fil, String filTxt) {
        Atomics.store((Int32Array)this.jsControlBuffer, (int)(2 + sidNum), (int)1);
        JSMapLike message = (JSMapLike)JSObjects.create();
        message.set("eventType", (Object)JSString.valueOf((String)"OSC_SAB"));
        JSMapLike eventData = (JSMapLike)JSObjects.create();
        eventData.set("sidNum", (Object)JSNumber.valueOf((int)sidNum));
        eventData.set("wav0Txt", (Object)JSString.valueOf((String)wav0Txt));
        eventData.set("wav1Txt", (Object)JSString.valueOf((String)wav1Txt));
        eventData.set("wav2Txt", (Object)JSString.valueOf((String)wav2Txt));
        eventData.set("env0Txt", (Object)JSString.valueOf((String)env0Txt));
        eventData.set("env1Txt", (Object)JSString.valueOf((String)env1Txt));
        eventData.set("env2Txt", (Object)JSString.valueOf((String)env2Txt));
        eventData.set("frq0Txt", (Object)JSString.valueOf((String)frq0Txt));
        eventData.set("frq1Txt", (Object)JSString.valueOf((String)frq1Txt));
        eventData.set("frq2Txt", (Object)JSString.valueOf((String)frq2Txt));
        eventData.set("volTxt", (Object)JSString.valueOf((String)volTxt));
        eventData.set("resTxt", (Object)JSString.valueOf((String)resTxt));
        eventData.set("filTxt", (Object)JSString.valueOf((String)filTxt));
        message.set("eventData", (Object)eventData);
        Window.worker().postMessage((JSObject)message);
        while (Atomics.load((Int32Array)this.jsControlBuffer, (int)(2 + sidNum)) == 1) {
            Atomics.wait((Int32Array)this.jsControlBuffer, (int)(2 + sidNum), (int)1, (int)50);
        }
    }

    @Override
    public void processSidWrite(long absTime, int relTime, int addr, int value) {
        ImportedApiSAB.processSidWriteJS(absTime, relTime, addr, value);
    }

    @Override
    public void processTimerEnd(double end) {
        ImportedApiSAB.processTimerEndJS(end);
    }

    @Override
    public void processPrinter(IPaper.Outputs output) {
        ImportedApiSAB.processPrinterJS(output.name());
    }

    @Override
    public void whatsSid(byte[] array) {
        ImportedApiSAB.whatsSidJS(array, array.length);
    }

    @Import(module="jsidplay2", name="processSidWrite")
    @JSBody(params={"at", "ti", "ad", "va"}, script="processSidWrite(at,ti,ad,va)")
    public static native void processSidWriteJS(double var0, int var2, int var3, int var4);

    @Import(module="jsidplay2", name="timerEnd")
    @JSBody(params={"ed"}, script="timerEnd(ed)")
    public static native void processTimerEndJS(double var0);

    @Import(module="jsidplay2", name="processPrinter")
    @JSBody(params={"op"}, script="processPrinter(op)")
    public static native void processPrinterJS(String var0);

    @Import(module="jsidplay2", name="whatsSid")
    @JSBody(params={"ar", "le"}, script="whatsSid(ar,le)")
    public static native void whatsSidJS(@JSByRef(optional=true) byte[] var0, int var1);

    public static class CONTROL {
        public static final int SAMPLE_FLAG_INDEX = 0;
        public static final int FRAME_FLAG_INDEX = 1;
        public static final int OSC0_FLAG_INDEX = 2;

        public static class FLAGS {
            public static final int NOT_READY = 0;
            public static final int READY = 1;
        }
    }
}

